//*************************************************************************
//** OPOS POSPrinter Constants
//*************************************************************************

typedef [helpstring("OPOS POSPrinter Constants")]
enum
{
    PTR_S_JOURNAL                             = 1,
    PTR_S_RECEIPT                             = 2,
    PTR_S_SLIP                                = 4,
    PTR_S_JOURNAL_RECEIPT                     = 0x0003,
    PTR_S_JOURNAL_SLIP                        = 0x0005,
    PTR_S_RECEIPT_SLIP                        = 0x0006,
    PTR_TWO_RECEIPT_JOURNAL                   = 0x8003,
    PTR_TWO_SLIP_JOURNAL                      = 0x8005,
    PTR_TWO_SLIP_RECEIPT                      = 0x8006,
    PTR_CCS_ALPHA                             = 1,
    PTR_CCS_ASCII                             = 998,
    PTR_CCS_KANA                              = 10,
    PTR_CCS_KANJI                             = 11,
    PTR_CCS_UNICODE                           = 997,
    PTR_CS_UNICODE                            = 997,
    PTR_CS_ASCII                              = 998,
    PTR_CS_WINDOWS                            = 999,
    PTR_CS_ANSI                               = 999,
    PTR_EL_NONE                               = 1,
    PTR_EL_RECOVERABLE                        = 2,
    PTR_EL_FATAL                              = 3,
    PTR_MM_DOTS                               = 1,
    PTR_MM_TWIPS                              = 2,
    PTR_MM_ENGLISH                            = 3,
    PTR_MM_METRIC                             = 4,
    PTR_COLOR_PRIMARY                         = 0x00000001,
    PTR_COLOR_CUSTOM1                         = 0x00000002,
    PTR_COLOR_CUSTOM2                         = 0x00000004,
    PTR_COLOR_CUSTOM3                         = 0x00000008,
    PTR_COLOR_CUSTOM4                         = 0x00000010,
    PTR_COLOR_CUSTOM5                         = 0x00000020,
    PTR_COLOR_CUSTOM6                         = 0x00000040,
    PTR_COLOR_CYAN                            = 0x00000100,
    PTR_COLOR_MAGENTA                         = 0x00000200,
    PTR_COLOR_YELLOW                          = 0x00000400,
    PTR_COLOR_FULL                            = 0x80000000,
    PTR_CART_UNKNOWN                          = 0x10000000,
    PTR_CART_OK                               = 0x00000000,
    PTR_CART_REMOVED                          = 0x00000001,
    PTR_CART_EMPTY                            = 0x00000002,
    PTR_CART_NEAREND                          = 0x00000004,
    PTR_CART_CLEANING                         = 0x00000008,
    PTR_CN_DISABLED                           = 0x00000000,
    PTR_CN_ENABLED                            = 0x00000001,
    PTR_PM_BITMAP                             = 0x00000001,
    PTR_PM_BARCODE                            = 0x00000002,
    PTR_PM_BM_ROTATE                          = 0x00000004,
    PTR_PM_BC_ROTATE                          = 0x00000008,
    PTR_PM_OPAQUE                             = 0x00000010,
    PTR_PD_LEFT_TO_RIGHT                      = 1,
    PTR_PD_BOTTOM_TO_TOP                      = 2,
    PTR_PD_RIGHT_TO_LEFT                      = 3,
    PTR_PD_TOP_TO_BOTTOM                      = 4,
    PTR_CP_FULLCUT                            = 100,
    PTR_PM_PAGE_MODE                          = 1,
    PTR_PM_PRINT_SAVE                         = 2,
    PTR_PM_NORMAL                             = 3,
    PTR_PM_CANCEL                             = 4,
    PTR_BC_LEFT                               = -1,
    PTR_BC_CENTER                             = -2,
    PTR_BC_RIGHT                              = -3,
    PTR_BC_TEXT_NONE                          = -11,
    PTR_BC_TEXT_ABOVE                         = -12,
    PTR_BC_TEXT_BELOW                         = -13,
    PTR_BCS_UPCA                              = 101,
    PTR_BCS_UPCE                              = 102,
    PTR_BCS_JAN8                              = 103,
    PTR_BCS_EAN8                              = 103,
    PTR_BCS_JAN13                             = 104,
    PTR_BCS_EAN13                             = 104,
    PTR_BCS_TF                                = 105,
    PTR_BCS_ITF                               = 106,
    PTR_BCS_Codabar                           = 107,
    PTR_BCS_Code39                            = 108,
    PTR_BCS_Code93                            = 109,
    PTR_BCS_Code128                           = 110,
    PTR_BCS_UPCA_S                            = 111,
    PTR_BCS_UPCE_S                            = 112,
    PTR_BCS_UPCD1                             = 113,
    PTR_BCS_UPCD2                             = 114,
    PTR_BCS_UPCD3                             = 115,
    PTR_BCS_UPCD4                             = 116,
    PTR_BCS_UPCD5                             = 117,
    PTR_BCS_EAN8_S                            = 118,
    PTR_BCS_EAN13_S                           = 119,
    PTR_BCS_EAN128                            = 120,
    PTR_BCS_OCRA                              = 121,
    PTR_BCS_OCRB                              = 122,
    PTR_BCS_Code128_Parsed                    = 123,
    PTR_BCS_RSS14                             = 131,
    PTR_BCS_RSS_EXPANDED                      = 132,
    PTR_BCS_GS1DATABAR                        = 131,
    PTR_BCS_GS1DATABAR_E                      = 132,
    PTR_BCS_GS1DATABAR_S                      = 133,
    PTR_BCS_GS1DATABAR_E_S                    = 134,
    PTR_BCS_PDF417                            = 201,
    PTR_BCS_MAXICODE                          = 202,
    PTR_BCS_DATAMATRIX                        = 203,
    PTR_BCS_QRCODE                            = 204,
    PTR_BCS_UQRCODE                           = 205,
    PTR_BCS_AZTEC                             = 206,
    PTR_BCS_UPDF417                           = 207,
    PTR_BCS_OTHER                             = 501,
    PTR_BM_ASIS                               = -11,
    PTR_BM_LEFT                               = -1,
    PTR_BM_CENTER                             = -2,
    PTR_BM_RIGHT                              = -3,
    PTR_BMT_BMP                               = 1,
    PTR_BMT_JPEG                              = 2,
    PTR_BMT_GIF                               = 3,
    PTR_RP_NORMAL                             = 0x0001,
    PTR_RP_RIGHT90                            = 0x0101,
    PTR_RP_LEFT90                             = 0x0102,
    PTR_RP_ROTATE180                          = 0x0103,
    PTR_RP_BARCODE                            = 0x1000,
    PTR_RP_BITMAP                             = 0x2000,
    PTR_L_TOP                                 = 1,
    PTR_L_BOTTOM                              = 2,
    PTR_TP_TRANSACTION                        = 11,
    PTR_TP_NORMAL                             = 12,
    PTR_MF_TO_TAKEUP                          = 1,
    PTR_MF_TO_CUTTER                          = 2,
    PTR_MF_TO_CURRENT_TOF                     = 4,
    PTR_MF_TO_NEXT_TOF                        = 8,
    PTR_PS_UNKNOWN                            = 0,
    PTR_PS_SIDE1                              = 1,
    PTR_PS_SIDE2                              = 2,
    PTR_PS_OPPOSITE                           = 3,
    PTR_RL_HORIZONTAL                         = 1,
    PTR_RL_VERTICAL                           = 2,
    PTR_LS_SINGLE_SOLID_LINE                  = 1,
    PTR_LS_DOUBLE_SOLID_LINE                  = 2,
    PTR_LS_BROKEN_LINE                        = 3,
    PTR_LS_CHAIN_LINE                         = 4,
    PTR_SUE_COVER_OPEN                        = 11,
    PTR_SUE_COVER_OK                          = 12,
    PTR_SUE_JRN_COVER_OPEN                    = 60,
    PTR_SUE_JRN_COVER_OK                      = 61,
    PTR_SUE_REC_COVER_OPEN                    = 62,
    PTR_SUE_REC_COVER_OK                      = 63,
    PTR_SUE_SLP_COVER_OPEN                    = 64,
    PTR_SUE_SLP_COVER_OK                      = 65,
    PTR_SUE_JRN_EMPTY                         = 21,
    PTR_SUE_JRN_NEAREMPTY                     = 22,
    PTR_SUE_JRN_PAPEROK                       = 23,
    PTR_SUE_REC_EMPTY                         = 24,
    PTR_SUE_REC_NEAREMPTY                     = 25,
    PTR_SUE_REC_PAPEROK                       = 26,
    PTR_SUE_SLP_EMPTY                         = 27,
    PTR_SUE_SLP_NEAREMPTY                     = 28,
    PTR_SUE_SLP_PAPEROK                       = 29,
    PTR_SUE_JRN_CARTRIDGE_EMPTY               = 41,
    PTR_SUE_JRN_CARTRIDGE_NEAREMPTY           = 42,
    PTR_SUE_JRN_HEAD_CLEANING                 = 43,
    PTR_SUE_JRN_CARTRIDGE_OK                  = 44,
    PTR_SUE_REC_CARTRIDGE_EMPTY               = 45,
    PTR_SUE_REC_CARTRIDGE_NEAREMPTY           = 46,
    PTR_SUE_REC_HEAD_CLEANING                 = 47,
    PTR_SUE_REC_CARTRIDGE_OK                  = 48,
    PTR_SUE_SLP_CARTRIDGE_EMPTY               = 49,
    PTR_SUE_SLP_CARTRIDGE_NEAREMPTY           = 50,
    PTR_SUE_SLP_HEAD_CLEANING                 = 51,
    PTR_SUE_SLP_CARTRIDGE_OK                  = 52,
    PTR_SUE_IDLE                              = 1001,
    OPOS_EPTR_COVER_OPEN                      = 201,
    OPOS_EPTR_JRN_EMPTY                       = 202,
    OPOS_EPTR_REC_EMPTY                       = 203,
    OPOS_EPTR_SLP_EMPTY                       = 204,
    OPOS_EPTR_SLP_FORM                        = 205,
    OPOS_EPTR_TOOBIG                          = 206,
    OPOS_EPTR_BADFORMAT                       = 207,
    OPOS_EPTR_JRN_CARTRIDGE_REMOVED           = 208,
    OPOS_EPTR_JRN_CARTRIDGE_EMPTY             = 209,
    OPOS_EPTR_JRN_HEAD_CLEANING               = 210,
    OPOS_EPTR_REC_CARTRIDGE_REMOVED           = 211,
    OPOS_EPTR_REC_CARTRIDGE_EMPTY             = 212,
    OPOS_EPTR_REC_HEAD_CLEANING               = 213,
    OPOS_EPTR_SLP_CARTRIDGE_REMOVED           = 214,
    OPOS_EPTR_SLP_CARTRIDGE_EMPTY             = 215,
    OPOS_EPTR_SLP_HEAD_CLEANING               = 216
} OPOSPOSPrinterConstants;
