//*************************************************************************
//** OPOS ElectronicValueRW Constants
//*************************************************************************

typedef [helpstring("OPOS ElectronicValueRW Constants")]
enum
{
    EVRW_CCS_ENTRY                            = 0x00000001,
    EVRW_CCS_DETECT                           = 0x00000002,
    EVRW_CCS_CAPTURE                          = 0x00000004,
    EVRW_CDC_RWCONTROL                        = 0x00000001,
    EVRW_CDC_APPLICATIONCONTROL               = 0x00000002,
    EVRW_DS_NOCARD                            = 1,
    EVRW_DS_DETECTED                          = 2,
    EVRW_DS_ENTERED                           = 3,
    EVRW_DS_CAPTURED                          = 4,
    EVRW_LS_OK                                = 1,
    EVRW_LS_NEARFULL                          = 2,
    EVRW_LS_FULL                              = 3,
    EVRW_PIN_ENTRY_NONE                       = 1,
    EVRW_PIN_ENTRY_EXTERNAL                   = 2,
    EVRW_PIN_ENTRY_INTERNAL                   = 3,
    EVRW_PIN_ENTRY_UNKNOWN                    = 4,
    EVRW_ST_UNSPECIFIED                       = 0,
    EVRW_ST_ELECTRONIC_MONEY                  = 1,
    EVRW_ST_POINT                             = 2,
    EVRW_ST_VOUCHER                           = 3,
    EVRW_ST_MEMBERSHIP                        = 4,
    EVRW_TM_FALSE                             = 1,
    EVRW_TM_TRUE                              = 2,
    EVRW_TM_UNKNOWN                           = 3,
    EVRW_AD_KEY                               = 1,
    EVRW_AD_NEGATIVE_LIST                     = 2,
    EVRW_AD_OTHERS                            = 3,
    EVRW_AL_REPORTING                         = 1,
    EVRW_AL_SETTLEMENT                        = 2,
    EVRW_BD_ANY                               = 1,
    EVRW_BD_SPECIFIC                          = 2,
    EVRW_TAG_AS_AUTHENTICATED                 = 1,
    EVRW_TAG_AS_UNAUTHENTICATED               = 2,
    EVRW_TAG_CTT_CANCEL                       = 1,
    EVRW_TAG_CTT_CHARGE                       = 2,
    EVRW_TAG_CTT_RETURN                       = 3,
    EVRW_TAG_CTT_SALES                        = 4,
    EVRW_TAG_CM_CASH                          = 1,
    EVRW_TAG_CM_CREDIT                        = 2,
    EVRW_TAG_CM_POINT                         = 3,
    EVRW_TAG_NIT_ALL                          = 1,
    EVRW_TAG_NIT_UPDATED                      = 2,
    EVRW_TAG_PC_INSTALLMENT_1                 = 1,
    EVRW_TAG_PC_INSTALLMENT_2                 = 2,
    EVRW_TAG_PC_INSTALLMENT_3                 = 3,
    EVRW_TAG_PC_BONUS_1                       = 4,
    EVRW_TAG_PC_BONUS_2                       = 5,
    EVRW_TAG_PC_BONUS_3                       = 6,
    EVRW_TAG_PC_BONUS_4                       = 7,
    EVRW_TAG_PC_BONUS_5                       = 8,
    EVRW_TAG_PC_BONUS_COMBINATION_1           = 9,
    EVRW_TAG_PC_BONUS_COMBINATION_2           = 10,
    EVRW_TAG_PC_BONUS_COMBINATION_3           = 11,
    EVRW_TAG_PC_BONUS_COMBINATION_4           = 12,
    EVRW_TAG_PC_LUMP                          = 13,
    EVRW_TAG_PC_REVOLVING                     = 14,
    EVRW_TAG_PM_COMBINED                      = 1,
    EVRW_TAG_PM_FULL_SETTLEMENT               = 2,
    EVRW_TAG_PMFP_CASH                        = 1,
    EVRW_TAG_PMFP_CREDIT                      = 2,
    EVRW_TAG_PMFP_EM                          = 3,
    EVRW_TAG_PMFP_OTHER                       = 4,
    EVRW_TAG_ROS_NG                           = 1,
    EVRW_TAG_ROS_OK                           = 2,
    EVRW_TAG_ROS_UNKNOWN                      = 3,
    EVRW_TAG_STT_1                            = 1,
    EVRW_TAG_STT_2                            = 2,
    EVRW_TAG_STT_3                            = 3,
    EVRW_TAG_TT_ADD                           = 1,
    EVRW_TAG_TT_CANCEL_CHARGE                 = 2,
    EVRW_TAG_TT_CANCEL_RETURN                 = 3,
    EVRW_TAG_TT_CANCEL_SALES                  = 4,
    EVRW_TAG_TT_GET_LOG                       = 5,
    EVRW_TAG_TT_READ                          = 6,
    EVRW_TAG_TT_RETURN                        = 7,
    EVRW_TAG_TT_SUBTRACT                      = 8,
    EVRW_TAG_TT_WRITE                         = 9,
    EVRW_TA_TRANSACTION                       = 11,
    EVRW_TA_NORMAL                            = 12,
    EVRW_SUE_LS_OK                            = 11,
    EVRW_SUE_LS_NEARFULL                      = 12,
    EVRW_SUE_LS_FULL                          = 13,
    EVRW_SUE_DS_NOCARD                        = 21,
    EVRW_SUE_DS_DETECTED                      = 22,
    EVRW_SUE_DS_ENTERED                       = 23,
    EVRW_SUE_DS_CAPTURED                      = 24,
    EVRW_TE_NOTIFY_TOUCH_RETRY                = 1,
    EVRW_TE_NOTIFY_TOUCH_RETRY_CANCELABLE     = 2,
    EVRW_TE_CONFIRM_TOUCH_RETRY               = 3,
    EVRW_TE_CONFIRM_CANCEL                    = 4,
    EVRW_TE_NOTIFY_INVALID_OPERATION          = 5,
    EVRW_TE_CONFIRM_INVALID_OPERATION         = 6,
    EVRW_TE_CONFIRM_REMAINDER_SUBTRACTION     = 7,
    EVRW_TE_CONFIRM_CENTER_CHECK              = 8,
    EVRW_TE_CONFIRM_TOUCH_TIMEOUT             = 9,
    EVRW_TE_CONFIRM_AUTO_CHARGE               = 10,
    EVRW_TE_NOTIFY_CAPTURE_CARD               = 11,
    EVRW_TE_NOTIFY_PIN                        = 12,
    EVRW_TE_NOTIFY_CENTER_CHECK               = 13,
    EVRW_TE_NOTIFY_COMPLETE                   = 14,
    EVRW_TE_NOTIFY_TOUCH                      = 15,
    EVRW_TE_NOTIFY_BUSY                       = 16,
    EVRW_TE_CONFIRM_CENTER_CHECK_COMPLETE     = 17,
    EVRW_TE_CONFIRM_SELECT                    = 18,
    EVRW_TE_NOTIFY_LOCK                       = 19,
    EVRW_TE_NOTIFY_CENTER_CHECK_COMPLETE      = 20,
    EVRW_TE_CONFIRM_PIN_ENTRY_BY_OUTER_PINPAD = 21,
    EVRW_TE_NOTIFY_PROGRESS_1_TO_100          = 22,
    EVRW_TE_CONFIRM_DEVICE_DATA               = 23,
    OPOS_EVRW_NOCARD                          = 201,
    OPOS_EVRW_RELEASE                         = 202,
    OPOS_EVRW_CENTERERROR                     = 203,
    OPOS_EVRW_COMMANDERROR                    = 204,
    OPOS_EVRW_RESET                           = 205,
    OPOS_EVRW_COMMUNICATIONERROR              = 206,
    OPOS_EVRW_LOGOVERFLOW                     = 207,
    OPOS_EVRW_DAILYLOGOVERFLOW                = 208,
    OPOS_EVRW_DEFICIENT                       = 209,
    OPOS_EVRW_OVERDEPOSIT                     = 210
} OPOSElectronicValueRWConstants;
