//*************************************************************************
//** OPOS Biometrics Constants
//*************************************************************************

typedef [helpstring("OPOS Biometrics Constants")]
enum
{
    BIO_CSC_MONO                              = 0x00000001,
    BIO_CSC_GRAYSCALE                         = 0x00000002,
    BIO_CSC_16                                = 0x00000004,
    BIO_CSC_256                               = 0x00000008,
    BIO_CSC_FULL                              = 0x00000010,
    BIO_CSO_NORMAL                            = 0x00000001,
    BIO_CSO_RIGHT                             = 0x00000002,
    BIO_CSO_INVERTED                          = 0x00000004,
    BIO_CSO_LEFT                              = 0x00000008,
    BIO_CST_FACIAL_FEATURES                   = 0x00000001,
    BIO_CST_VOICE                             = 0x00000002,
    BIO_CST_FINGERPRINT                       = 0x00000004,
    BIO_CST_IRIS                              = 0x00000008,
    BIO_CST_RETINA                            = 0x00000010,
    BIO_CST_HAND_GEOMETRY                     = 0x00000020,
    BIO_CST_SIGNATURE_DYNAMICS                = 0x00000040,
    BIO_CST_KEYSTROKE_DYNAMICS                = 0x00000080,
    BIO_CST_LIP_MOVEMENT                      = 0x00000100,
    BIO_CST_THERMAL_FACE_IMAGE                = 0x00000200,
    BIO_CST_THERMAL_HAND_IMAGE                = 0x00000400,
    BIO_CST_GAIT                              = 0x00000800,
    BIO_CST_PASSWORD                          = 0x00001000,
    BIO_SC_MONO                               = 1,
    BIO_SC_GRAYSCALE                          = 2,
    BIO_SC_16                                 = 3,
    BIO_SC_256                                = 4,
    BIO_SC_FULL                               = 5,
    BIO_SO_NORMAL                             = 1,
    BIO_SO_RIGHT                              = 2,
    BIO_SO_INVERTED                           = 3,
    BIO_SO_LEFT                               = 4,
    BIO_ST_FACIAL_FEATURES                    = 1,
    BIO_ST_VOICE                              = 2,
    BIO_ST_FINGERPRINT                        = 3,
    BIO_ST_IRIS                               = 4,
    BIO_ST_RETINA                             = 5,
    BIO_ST_HAND_GEOMETRY                      = 6,
    BIO_ST_SIGNATURE_DYNAMICS                 = 7,
    BIO_ST_KEYSTROKE_DYNAMICS                 = 8,
    BIO_ST_LIP_MOVEMENT                       = 9,
    BIO_ST_THERMAL_FACE_IMAGE                 = 10,
    BIO_ST_THERMAL_HAND_IMAGE                 = 11,
    BIO_ST_GAIT                               = 12,
    BIO_ST_PASSWORD                           = 13,
    BIO_DATA_ENROLL                           = 1,
    BIO_DATA_VERIFY                           = 2,
    BIO_SUE_RAW_DATA                          = 1,
    BIO_SUE_MOVE_LEFT                         = 2,
    BIO_SUE_MOVE_RIGHT                        = 3,
    BIO_SUE_MOVE_DOWN                         = 4,
    BIO_SUE_MOVE_UP                           = 5,
    BIO_SUE_MOVE_CLOSER                       = 6,
    BIO_SUE_MOVE_AWAY                         = 7,
    BIO_SUE_MOVE_BACKWARD                     = 8,
    BIO_SUE_MOVE_FORWARD                      = 9,
    BIO_SUE_MOVE_SLOWER                       = 10,
    BIO_SUE_MOVE_FASTER                       = 11,
    BIO_SUE_SENSOR_DIRTY                      = 12,
    BIO_SUE_FAILED_READ                       = 13,
    BIO_SUE_SENSOR_READY                      = 14,
    BIO_SUE_SENSOR_COMPLETE                   = 15
} OPOSBiometricsConstants;
